/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWInstructionElement;
import filenet.vw.api.VWPersistentCollection;
import filenet.vw.api.VWQuery;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueElement;
import filenet.vw.api.VWStepElement;
import filenet.vw.api.VWWorkElement;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.logging.Logger;

public class VWQueueQuery
extends VWQuery {
    private static final long serialVersionUID = 7424L;
    protected static Logger logger = Logger.getLogger("filenet.vw.api.query");
    private static final String m_className = "VWQueueQuery";

    public static String _get_FILE_DATE() {
        return "$Date: 2010-02-22 22:06:31 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_452_Int/PUI_460_Int/1 $";
    }

    protected VWQueueQuery(VWPersistentCollection querySource, String index_Name, Object[] min_Values, Object[] max_Values, int query_Flags, String pre_Filter_SQL, Object[] substitution_Vars, int query_Type) throws VWException {
        super(querySource, index_Name, min_Values, max_Values, query_Flags, pre_Filter_SQL, substitution_Vars, query_Type);
    }

    protected VWQueueQuery(VWPersistentCollection querySource, String index_Name, Object[] min_Values, Object[] max_Values, int query_Flags, String pre_Filter_SQL, Object[] substitution_Vars, int query_Type, int buffer_Size, int fetch_Type) throws VWException {
        super(querySource, index_Name, min_Values, max_Values, query_Flags, pre_Filter_SQL, substitution_Vars, query_Type, buffer_Size, fetch_Type);
        if (querySource.userCentricServer != -1) {
            this.setUserBoundQueueQuery(true);
        }
    }

    public VWWorkObject[] fetchWorkObjects(int bufferSize) throws VWException {
        if (this.queryFetchType != -1) {
            throw new VWException("vw.api.fWNewQueueQueryObject", "VWQueueQuery object was created with new createQuery. Use method next() to fetch objects.");
        }
        if (this.fetchType != -1 && this.fetchType != 1) {
            throw new VWException("vw.api.QQFetchWorkObjectTypeChange", "New QueueQuery object required to change fetched object type");
        }
        this.fetchType = 1;
        this.setBufferSize(bufferSize);
        return (VWWorkObject[])this.fetch(1, VWWorkObject.class);
    }

    public VWQueueElement[] fetchQueueElements(int bufferSize) throws VWException {
        if (this.queryFetchType != -1) {
            throw new VWException("vw.api.fQNewQueueQueryObject", "VWQueueQuery object was created with new createQuery. Use method next() to fetch objects.");
        }
        if (this.fetchType != -1 && this.fetchType != 3) {
            throw new VWException("vw.api.QQFetchQueueElementTypeChange", "New QueueQuery object required to change fetched object type");
        }
        this.fetchType = 3;
        this.setBufferSize(bufferSize);
        return (VWQueueElement[])this.fetch(3, VWQueueElement.class);
    }

    public VWInstructionElement[] fetchInstructionElements(int bufferSize) throws VWException {
        if (this.queryFetchType != -1) {
            throw new VWException("vw.api.fINewQueueQueryObject", "VWQueueQuery object was created with new createQuery. Use method next() to fetch objects.");
        }
        if (this.fetchType != -1 && this.fetchType != 2) {
            throw new VWException("vw.api.QQFetchInstructionElementTypeChange", "New QueueQuery object required to change fetched object type");
        }
        this.fetchType = 2;
        this.setBufferSize(bufferSize);
        return (VWInstructionElement[])this.fetch(2, VWInstructionElement.class);
    }

    public VWQueue getQueue() {
        return (VWQueue)this.querySource;
    }

    public boolean isDone() {
        return this.endOfQuery();
    }

    public String toString() {
        return this.querySource.getName() + " QueueQuery";
    }

    public void resetFetch() {
        super.resetFetch();
    }

    public int getElementType() {
        return this.queryFetchType;
    }

    public Object next() throws VWException {
        Object result = null;
        boolean serverTrip = false;
        if (this.queryFetchType == -1) {
            throw new VWException("vw.api.QQOldQueueQueryObject", "VWQueueQuery object was created with deprecated startQuery. Use deprecated fetches or create new VWQueueQuery object from startQuery method that specifies the fetch type.");
        }
        if (this.fetchCount == this.returnCount) {
            serverTrip = true;
            this.dofetch();
        }
        if (this.fetchCount != 0) {
            result = this.fetchedObjects[this.returnCount];
            ++this.returnCount;
        }
        if (logger.isFinest() && result instanceof VWWorkElement) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.querySource.getName());
            if (serverTrip) {
                buf.append(" [server] ");
            }
            VWWorkElement wob = (VWWorkElement)result;
            buf.append(wob.getWorkObjectNumber());
            logger.finest(m_className, "next", buf.toString());
        }
        return result;
    }

    protected void dofetch() throws VWException {
        if (this.fetchCount == this.returnCount) {
            this.returnCount = 0;
            this.fetchCount = 0;
            this.fetchedObjects = null;
            if (!this.endOfQuery()) {
                switch (this.queryFetchType) {
                    case 1: {
                        this.fetchedObjects = this.fetch(1, VWWorkObject.class);
                        break;
                    }
                    case 2: {
                        this.fetchedObjects = this.fetch(2, VWInstructionElement.class);
                        break;
                    }
                    case 3: {
                        this.fetchedObjects = this.fetch(3, VWQueueElement.class);
                        break;
                    }
                    case 5: {
                        this.fetchedObjects = this.fetch(5, VWStepElement.class);
                        break;
                    }
                    default: {
                        throw new VWException("vw.api.QQBadType", "VWQueueQuery unsupported type of fetch.");
                    }
                }
                if (this.fetchedObjects != null) {
                    this.fetchCount = this.fetchedObjects.length;
                }
            }
        }
    }

    public boolean hasNext() throws VWException {
        if (this.queryFetchType == -1) {
            throw new VWException("vw.api.QQOldQueueQueryObject", "VWQueueQuery object was created with deprecated startQuery. Use deprecated fetches or create new VWQueueQuery object from startQuery method that specifies the fetch type.");
        }
        return super.hasNext();
    }

    public int fetchCount() throws VWException {
        int result = 0;
        switch (this.queryFetchType) {
            case 1: {
                result = super.fetchCount(1);
                break;
            }
            case 2: {
                result = super.fetchCount(2);
                break;
            }
            case 3: {
                result = super.fetchCount(3);
                break;
            }
            case 5: {
                result = super.fetchCount(5);
                break;
            }
            default: {
                throw new VWException("vw.api.QQBadType", "VWQueueQuery unsupported type of fetch");
            }
        }
        return result;
    }
}

